package com.agilex.healthcare.veteranappointment.dataservice;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.veteranappointment.datalayer.appointment.CCAppointmentRequestDataLayer;
import com.agilex.healthcare.veteranappointment.domain.CCAppointmentRequest;
import com.agilex.healthcare.veteranappointment.utils.VamfUserTransformer;

import gov.va.vamf.security.v1.VamfUser;
import org.springframework.stereotype.Component;
import gov.va.vamf.scheduling.direct.InstitutionService;
import gov.va.vamf.scheduling.direct.datalayer.facility.CustomFriendlyTextService;
import javax.annotation.Resource;
import java.util.Arrays;

@Component
public class CCAppointmentRequestDataService extends AppointmentRequestDataService {
    @Resource
    CCAppointmentRequestDataLayer ccAppointmentRequestDataLayer;

    @Resource
    InstitutionService institutionService;

    @Resource
    private CustomFriendlyTextService customFriendlyTextService;

    public CCAppointmentRequest saveCCAppointmentRequest(CCAppointmentRequest ccAppointmentRequest,
                                                         String haMode, boolean fullValidation, VamfUser vamfUser) {

        Patient patient = VamfUserTransformer.getPatient(vamfUser);

        if (NullChecker.isNullish(patient.getPatientIdentifier().getUniqueId())) {
            patient.setPatientIdentifier(ccAppointmentRequest.getPatientIdentifier());
        }
        patient.setTextMessagingAllowed(ccAppointmentRequest.isTextMessagingAllowed());
        patient.setTextMessagingPhoneNumber(ccAppointmentRequest.getTextMessagingPhoneNumber());

        ccAppointmentRequest.setPatient(patient);
        if (ccAppointmentRequest.getParentRequest() != null) {
            ccAppointmentRequest.getParentRequest().setPatient(patient);
        }

        addSurrogate(ccAppointmentRequest, vamfUser);

        updateAppointmentRequestsWithMongoFriendlyName(Arrays.asList(ccAppointmentRequest));

        CCAppointmentRequest result = ccAppointmentRequestDataLayer.saveCCAppointmentRequest(ccAppointmentRequest);
        result.setPatientIdentifier(ccAppointmentRequest.getPatientIdentifier());

        return result;
    }
}
